/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWException;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWCheckWorkflowNameDialog;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.workflow.VWSelectBaseWorkflowDialog;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class VWGeneralPanel
extends JPanel
implements IVWMapChangedListener,
IVWToolbarBorderActionListener,
FocusListener {
    private VWToolbarBorder m_baseWorkClassBorder = null;
    private JLabel m_baseWorkClassLabel = null;
    private VWToolbarBorder m_workflowNameBorder = null;
    private JTextField m_wflNameTextField = null;
    private JTextField m_subjectField = null;
    private JTextArea m_descriptionTextArea = null;
    private VWAuthPropertyData m_authPropertyData = null;

    VWGeneralPanel() {
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 555: {
                VWWorkflowDefinition workflowDefinition;
                this.m_wflNameTextField.setText("");
                if (this.m_authPropertyData == null || (workflowDefinition = this.m_authPropertyData.getWorkflowDefinition()) == null) break;
                this.m_wflNameTextField.setText(workflowDefinition.getName());
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        if (event.getSource().equals(this.m_baseWorkClassBorder)) {
            if (event.getID() == 32) {
                this.performSelectWorkflowBaseClass();
            }
        } else if (event.getSource().equals(this.m_workflowNameBorder) && event.getID() == 262144) {
            this.performCheckWorkflowNameAction();
        }
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        VWWorkflowDefinition workflowDefinition;
        if (this.m_authPropertyData != null && (workflowDefinition = this.m_authPropertyData.getWorkflowDefinition()) != null) {
            if (event.getSource().equals(this.m_wflNameTextField)) {
                try {
                    workflowDefinition.setName(this.m_wflNameTextField.getText());
                    this.m_authPropertyData.setDirty();
                    this.m_authPropertyData.getMapChangeEventNotifier().notifyMapChange(555);
                }
                catch (VWException ex) {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                    this.m_wflNameTextField.setText(workflowDefinition.getName());
                }
            } else if (event.getSource().equals(this.m_subjectField)) {
                workflowDefinition.setSubject('\"' + this.m_subjectField.getText() + '\"');
                this.m_authPropertyData.setDirty();
            } else if (event.getSource().equals(this.m_descriptionTextArea)) {
                workflowDefinition.setDescription(this.m_descriptionTextArea.getText());
                this.m_authPropertyData.setDirty();
            }
        }
    }

    protected void init(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.anchor = 19;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(7, 5, 5, 20);
            this.add((Component)this.getWorkflowPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.insets = new Insets(7, 5, 5, 5);
            this.add((Component)this.getDescriptionPanel(), gbCons);
            this.reinitialize();
            this.m_authPropertyData.getMapChangeEventNotifier().addMapChangedListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        try {
            VWWorkflowDefinition workflowDefinition;
            this.m_wflNameTextField.setText("");
            this.m_subjectField.setText("");
            this.m_descriptionTextArea.setText("");
            if (this.m_baseWorkClassLabel != null) {
                this.m_baseWorkClassLabel.setText("");
            }
            if (this.m_authPropertyData != null && (workflowDefinition = this.m_authPropertyData.getWorkflowDefinition()) != null) {
                if (this.m_baseWorkClassLabel != null) {
                    String baseWorkClassName = workflowDefinition.getBaseWorkClassName();
                    if (baseWorkClassName == null || baseWorkClassName.length() == 0) {
                        baseWorkClassName = "WorkObjectEx";
                    }
                    this.m_baseWorkClassLabel.setText(" " + baseWorkClassName);
                }
                this.m_wflNameTextField.setText(workflowDefinition.getName());
                String subject = workflowDefinition.getSubject();
                if (subject != null) {
                    boolean bFixup = false;
                    if (subject.startsWith("\"") || subject.startsWith("'")) {
                        subject = subject.substring(1, subject.length());
                    } else {
                        bFixup = true;
                    }
                    if (subject.endsWith("\"") || subject.endsWith("'")) {
                        subject = subject.substring(0, subject.length() - 1);
                    } else {
                        bFixup = true;
                    }
                    if (bFixup) {
                        workflowDefinition.setSubject('\"' + subject + '\"');
                        this.m_authPropertyData.setDirty();
                    }
                }
                this.m_subjectField.setText(subject);
                this.m_descriptionTextArea.setText(workflowDefinition.getDescription());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getMapChangeEventNotifier().removeMapChangedListener(this);
        if (this.m_baseWorkClassBorder != null) {
            this.m_baseWorkClassBorder.removeToolbarBorderActionNotifier(this);
            this.m_baseWorkClassBorder = null;
        }
        this.m_baseWorkClassLabel = null;
        if (this.m_workflowNameBorder != null) {
            this.m_workflowNameBorder.removeToolbarBorderActionNotifier(this);
            this.m_workflowNameBorder = null;
        }
        if (this.m_wflNameTextField != null) {
            this.m_wflNameTextField.removeFocusListener(this);
            this.m_wflNameTextField = null;
        }
        if (this.m_subjectField != null) {
            this.m_subjectField.removeFocusListener(this);
            this.m_subjectField = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeFocusListener(this);
            this.m_descriptionTextArea = null;
        }
        this.m_authPropertyData = null;
    }

    private void performSelectWorkflowBaseClass() {
        try {
            VWSelectBaseWorkflowDialog newDialog;
            String baseWorkClassName = this.m_baseWorkClassLabel.getText();
            if (baseWorkClassName != null && baseWorkClassName.charAt(0) == ' ') {
                baseWorkClassName = baseWorkClassName.substring(1, baseWorkClassName.length());
            }
            if ((newDialog = new VWSelectBaseWorkflowDialog(this.m_authPropertyData, baseWorkClassName)) != null) {
                newDialog.setVisible(true);
                if (newDialog.getResult() == 1) {
                    String baseWorkflowClassName = newDialog.getBaseWorkflowClassName();
                    this.m_authPropertyData.updateWorkflowBaseClass(baseWorkflowClassName);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performCheckWorkflowNameAction() {
        String workflowName = this.m_wflNameTextField.getText();
        VWCheckWorkflowNameDialog checkWorkflowNameDialog = new VWCheckWorkflowNameDialog(this.m_authPropertyData.getSessionInfo(), workflowName);
        checkWorkflowNameDialog.setVisible(true);
        if (checkWorkflowNameDialog.getExitStatus() == 0) {
            String newWorkflowName = checkWorkflowNameDialog.getWorkflowName();
            this.m_wflNameTextField.setText(newWorkflowName);
        }
    }

    private JPanel getWorkflowPanel() {
        try {
            JPanel workflowPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 2, 2, 2);
            if (this.m_authPropertyData.getShowInheritedProperties()) {
                this.m_baseWorkClassBorder = new VWToolbarBorder(VWResource.s_baseWorkflow, 32);
                this.m_baseWorkClassBorder.addToolbarBorderActionNotifier(this);
                JPanel baseWorkClassPanel = this.m_baseWorkClassBorder.getClientPanel();
                baseWorkClassPanel.setLayout(new GridLayout());
                this.m_baseWorkClassLabel = new JLabel("");
                baseWorkClassPanel.add(this.m_baseWorkClassLabel);
                workflowPanel.add((Component)this.m_baseWorkClassBorder, gbCons);
            }
            ++gbCons.gridy;
            gbCons.insets = new Insets(2, 2, 2, 2);
            this.m_workflowNameBorder = new VWToolbarBorder(VWResource.s_workflowNameStr, 262144);
            this.m_workflowNameBorder.addToolbarBorderActionNotifier(this);
            JPanel workflowNamePanel = this.m_workflowNameBorder.getClientPanel();
            workflowNamePanel.setLayout(new GridLayout());
            this.m_wflNameTextField = new JTextField();
            this.m_wflNameTextField.setName("m_wflNameTextField_VWGeneralPanel");
            this.m_wflNameTextField.setColumns(25);
            this.m_wflNameTextField.addFocusListener(this);
            workflowNamePanel.add(this.m_wflNameTextField);
            workflowPanel.add((Component)this.m_workflowNameBorder, gbCons);
            ++gbCons.gridy;
            VWToolbarBorder subjectBorder = new VWToolbarBorder(VWResource.s_subjectStr, 0x40000000);
            JPanel subjectPanel = subjectBorder.getClientPanel();
            subjectPanel.setLayout(new GridLayout());
            this.m_subjectField = new JTextField();
            this.m_subjectField.setName("m_subjectField_VWGeneralPanel");
            this.m_subjectField.setColumns(25);
            this.m_subjectField.addFocusListener(this);
            subjectPanel.add(this.m_subjectField);
            workflowPanel.add((Component)subjectBorder, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            workflowPanel.add((Component)new JLabel(" "), gbCons);
            return workflowPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return new JPanel();
        }
    }

    private JPanel getDescriptionPanel() {
        try {
            VWToolbarBorder descriptionBorder = new VWToolbarBorder(VWResource.s_descriptionStr, 0x40000000);
            JPanel descriptionPanel = descriptionBorder.getClientPanel();
            descriptionPanel.setLayout(new BorderLayout());
            this.m_descriptionTextArea = new JTextArea();
            this.m_descriptionTextArea.setName("m_descriptionTextArea_VWGeneralPanel");
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.setRows(5);
            this.m_descriptionTextArea.addFocusListener(this);
            descriptionPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), "Center");
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            descriptionPanel.applyComponentOrientation(compOrientation);
            return descriptionBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return new JPanel();
        }
    }
}

